/******************************************************************************
 *  uboot_load                                                                *
 *  Copyright (C) 2005 Everett Coleman <gcc80x86@fuzzyneural.net>             *
 *  http://fuzzyneural.net                                                    *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 ******************************************************************************/
#ifndef __uboot_load_h_20041203__
# define __uboot_load_h_20041203__ 1

# include <errno.h>
# include <limits.h>
# include <stdint.h>
# include <stdio.h>
# include <string.h>
# include <unistd.h>
# include "config.h"


# ifndef PATH_MAX
#  define PATH_MAX 256
# endif /* PATH_MAX */

# define DEFAULT_PORT    9999
# define DEFAULT_LOADER "u-boot.bin"
# define DEFAULT_KERNEL  "bzImage"
# define DEFAULT_INITRD  "xinitrd"

# define DEST_TAGS   0x10000100
# define DEST_KERNEL 0x10008000
# define DEST_INITRD 0x10800000

# define get_flag(x,y) ((x&y) == y)
# define set_flag(x,y) (x|=y)
# define unset_flag(x,y) (x&=~y)

typedef struct {
# define FLAG_DONE (1<<0)
  uint32_t flags;
  int sock;

  char directory[PATH_MAX];
  char kernel[PATH_MAX];
  char initrd[PATH_MAX];
  char loader[PATH_MAX];
  char command[1024];
  uint32_t mach;
  uint32_t heap;
} uboot_t;

typedef struct _image_t {
	uint32_t src;
	uint32_t dst;
	uint32_t size;
} image_t;

typedef struct _bootstrap_param_t {
//	uint32_t xxx;
	// tags information
	uint32_t tags_size;    // 0
	uint32_t tags_src;     // 4
	uint32_t tags_dst;     // 8

	// Kernel information
	uint32_t kernel_size;  // 12
	uint32_t kernel_src;   // 16
	uint32_t kernel_dst;   // 20

	// Initrd information
	uint32_t initrd_size;  // 24
	uint32_t initrd_src;   // 28
	uint32_t initrd_dst;   // 32
	
	// Machine type
	int			  type;             // 34

	// Second bootstrap address
	// it's optional.
	uint32_t bootstrap;   //  36
} bootstrap_param_t;

typedef struct {
  size_t s_size;
  char **s_list;
} strv_t;

/* file: uboot_load.c               */
int ub_init (uboot_t *);
void ub_free (uboot_t *);

void wreport_error (const char *, ...);

/* file: svc_net.c                 */
int svc_open (uboot_t *);
int svc_close (uboot_t *);
int svc_accept (uboot_t *);

/* file: command.c                 */
int cmd_loop (uboot_t *, FILE *, FILE *);
int cmd_file (uboot_t *, const char *);
void cmd_print (FILE *, const char *, ...);

/* file: config.c                  */
const char *cfg_fixfile (uboot_t *, const char *);

/* file: bload.c                   */
void bload_load (FILE *, uboot_t *);

#endif /* __uboot_load_h_20041203__ */
