/******************************************************************************
 *  uboot_load                                                                *
 *  Copyright (C) 2005 Everett Coleman <gcc80x86@fuzzyneural.net>             *
 *  http://fuzzyneural.net                                                    *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 ******************************************************************************/
#include <stdarg.h>
#ifdef WIN32
# include <WIN/windows.h>
#endif /* WIN32 */
#include "uboot_load.h"
#include <stdlib.h>
#include <wchar.h>

void wp_erase (void);

int
main (int argc, char *argv[]) {
  int ex=0;
  uboot_t ob;

  if ((ex=ub_init (&ob)))
    wreport_error ("ub_init: %s\r\n", strerror (errno));
  
  cmd_file (&ob, "uboot.txt");
  cmd_file (&ob, "\\My Documents\\uboot.txt");
  cmd_file (&ob, "\\Storage Card\\uboot.txt");
  cmd_file (&ob, "\\CF Card\\uboot.txt");
  
  if (!ex && (ex=svc_open (&ob)))
    wreport_error ("svc_open: %s\r\n", strerror (errno));

  if (!ex && (ex=svc_accept (&ob)))
    wreport_error ("svc_accept: %s\r\n", strerror (errno));

  svc_close (&ob);
	wp_erase ();
  ub_free (&ob);
  return 0;
} /* main */

int
ub_init (uboot_t *o) {
  if (!o)
    return 1;
  memset (o, 0, sizeof (uboot_t));
  return 0;
} /* ub_init */

void
ub_free (uboot_t *o) {
  if (!o)
    return;
} /* ub_free */

void
wreport_error (const char *format, ...) {
  va_list ap;
  char     buf[1024];
  wchar_t obuf[1024];
	extern int swprintf (const wchar_t *, size_t, const wchar_t *, ...);

  va_start (ap, format);
  vsnprintf (buf, sizeof (buf), format, ap);
  va_end (ap);

  swprintf (obuf, sizeof (obuf)/sizeof (wchar_t), L"%s", buf);
#ifdef WIN32
  MessageBoxW (NULL, obuf, L"ERROR", MB_OK);
#else
  fwprintf (stderr, obuf);
#endif /* WIN32 */
} /* wreport_error */
