		area	|.text|, CODE

; Set mode to supervisor
; disable interupt
; disable MMU
; Copy image to the required location
;
; parameters:
; r0	Jump label physical addres
; r1	parameters
		export	|bootstrap_start|
		export	|bootstrap_end|
		export	|Jump|
		export	|boot|
|boot|	proc
		
		; Disable intrupts
		mrs	r4, cpsr
		orr	r4, r4, #0xc0
		msr	cpsr_c, r4

		mov     r4, #0x00000004
        mov     ip, #0
        mov     r5, #0xff << 4
|Flush|	mcr     p15,0,r5,c7,c14,2
        subs    r5, r5, #1 << 4
        bcs	|Flush|
        tst	r4, #0x00000004
        
		mcrne   p15, 0, ip, c7, c5, 0   ; invalidate I cache
        mcrne   p15, 0, ip, c7, c10, 4  ; drain WB
		mcrne	p15, 0, ip, c8, c7, 0	; invalidate I-D TLB
		
		; set VC32 mode
        mrs     r4,cpsr
        bic     r4,r4,#0x1f
        orr     r4,r4,#0xd3
        msr     cpsr,r4

        ; Set up 925T mode
        mov		r4, #0x81
        mcr		p15,0, r4, c15, c1, 0
 
		mov		r4, #0
		mcrne	p15, 0, r4, c7, c10, 4	; Drain write buffer
		mcrne	p15, 0, r4, c7, c7, 0	; invalidate I+D & BTB
		
		
  		; disable MMU stuff and caches
		mrc     p15, 0, ip, c1, c0, 0
 		bic     ip, ip, #0x00002300     ; clear bits 13, 9:8 (--V- --RS)
 		bic     ip, ip, #0x00000087     ; clear bits 7, 2:0 (B--- -CAM)
 		orr     ip, ip, #0x00000002     ; set bit 2 (A) Align
 		orr     ip, ip, #0x00001000     ; set bit 12 (I) I-Cache
		nop
 		mcr     p15, 0, ip, c1, c0, 0
		mov		pc, r0					; Jump to the physical address
		nop	
|Jump|
		nop
		nop

	
|bootstrap_start|	nop			; This code will be relocated to
					nop			; upper 32M, so we don't overlap
					nop			; with linux kernel and initrd
	

		mov		r9,#0x13000000
		orr		r9,r9,#0x00ff0000
		orr		r9,r9,#0x0000f000

		mov		r0, #500
		mov     r2, #0x20000000
        orr     r2, r2, #0x00000120
        orr		r2, r2, #0x00004000
        add     r3, r2, #153600
|cls|   str     r0, [r2], #4
        teq     r2,r3
        bne		|cls|


		mov		r7, r1				; Save it  for later

		; Move tags
		ldmia	r1!,{r2,r3,r4}		; Read size/src/dst
|L1|	ldr		r5,[r3], #4
		str		r5,[r4], #4
		sub		r2, r2, #4
		teq		r2,#0
		bne		|L1|

		; Move kernel Image
		ldmia	r1!,{r2,r3,r4}		; Read size/src/dst
		teq		r2, #0
		beq		|Done|
|L2|	ldr		r5,[r3], #4
		str		r5,[r4], #4
		sub		r2, r2, #4
		teq		r2,#0
		bne		|L2| 

		
		; Move Initrd
		ldmia	r1!,{r2,r3,r4}		; Read size/src/dst
		teq		r2, #0
		beq		|Done|
|L3|	ldr		r5,[r3], #4
		str		r5,[r4], #4
		sub		r2, r2, #4
		teq		r2,#0
		bne		|L3|

|Done|
		
		mov		r0, #0
		ldr		r1, [r7, #36]	;Machine Type
		ldr		r2, [r7, #4]	; Tag address
		ldr		r3, [r7, #20]	; Kernel address
	
		; If we don't have second bootstrap
		; jump to kernel image
		ldr		r4, [r7, #40]
		teq		r4, #0
		beq		|linux|
		mov		pc, r4			; Jump tp second boot loader
		

|linux|
		mov	pc, r3				; Start kernel

|bootstrap_end|	nop			; End of linux bootstrap					; Jumb to the entry point 	
		endp
	end
