#include <video.h>
#include <font.h>
#include <config.h>

typedef struct {
        uint16_t ctrl;
        uint16_t top_l;
        uint16_t top_h;
        uint16_t bottom_l;
        uint16_t bottom_h;
}lcd_dma_t;

tty_device_t tty_video_device = {
	.puts = NULL,
	.putc = NULL,
	.getc = NULL
};

window_t win = {
        .height	= 320,
        .width	= 240,
        .bg	= 0x0000,
        .fg	= 0xffff,
        .x	= 0,
        .y	= 0,
        .size	= 76800,
        .buffer	= (uint16_t *) 0x20004120
};

static void
draw_char(char c){
	uint16_t *out	=NULL;
	uint16_t row	= 0;
	uint16_t col	= 0;
	uint8_t  bits	= 0x80;
	uint8_t  *ch	= &font[c * FONT_HEIGHT];

	// Draw the charcher line by line
	for(row = 0; row < FONT_HEIGHT; ++row){
		out  = &win.buffer[LOC(win.x ,win.y + row)];
		bits = 0x80;

		// Draw row
		for(col = 0; col < FONT_WIDTH; col++){
			bits >>= 1;
			if(bits & ch[row]){
				// Use back ground
				out[col]	= win.fg;
			}else {
				out[col]	= win.bg;

			}
		}
	}
}

static void 
shift_window_up(){
	// Calculate the size of line
	uint32_t line = (win.width * FONT_HEIGHT) * 2;
	
	// Size of the buffer with
	// out the shifted line
	uint32_t size = win.size - line;

	
	uint16_t *src = &win.buffer[line];
	uint16_t *dst = &win.buffer[0];

	while(size--){
		*dst = *src;

		++src;
		++dst;
	}

	// Clear the last line
	//dst = &win.buffer[win.size - line];
	while(line--){
		*dst = win.bg;
		++dst;
	}
}

void
win_cleanup(){
        // Size of the buffer
        uint32_t size  	= win.size;
        uint16_t *dst  	= &win.buffer[0];

	// Paint the screen with background
	// color.
	while(size--){
                *dst = win.bg;
                ++dst;
        }

	// Reset cursor position
	win.x = 0;
	win.y = 0;

	tty_video_device.puts = win_puts;
	tty_video_device.putc = win_putc;
	tty_video_device.getc = NULL;
}

void 
move_cursor(uint16_t col, uint16_t row){
	win.x = (col * FONT_WIDTH);
	win.y = (row * FONT_HEIGHT);

	if(win.x > win.width){
		// Move to the next line
		win.y = win.y + FONT_HEIGHT;
		win.x = 0;
	}

	if(win.y > win.height){
		// Shift the screen.
		shift_window_up();

		win.y = win.y - FONT_HEIGHT;
		win.x = 0;
	}

}

void
win_putc(char c){
	switch(c){
	case '\n':
		// Move to the begining of 
		// the next line
		win.x = 0;
		win.y = win.y + FONT_HEIGHT;
		break;
	case '\r':
		// Move to the begining of the line
		win.x = 0;
		break;
	case '\t':
		// Add 4 spaces
		win.x += FONT_WIDTH * 4;
		break;
	case ' ':
		// Add one space
		win.x += FONT_WIDTH;
		break;
	default:
		// Print character
		draw_char(c);

		// Move cursor
		win.x += FONT_WIDTH;
		break;
	}

	if(win.x >= win.width){
		// Move to the next line
		win.y = win.y + FONT_HEIGHT;
		win.x = 0;
	}

	if(win.y >= win.height){
		// Shift the screen.
		shift_window_up();

		win.y = win.height - FONT_HEIGHT;
		win.x = 0;
	}
}

void
win_puts(char *str){
	char	 *ptr = str;
	
	while(*ptr){
		win_putc(*ptr);
		ptr++;
	}
}

void
set_fg_color(uint16_t color){
	win.fg = color;
}

void
set_bg_color(uint16_t color){
	win.bg = color;
}
