#ifndef _FS_H
#define _FS_H

#include <xtype.h>
#include <part.h>
#include <device.h>


#define MAX_FILE_NAME	256

typedef void *fd_t;
typedef void *supper_block_t;

struct _inode_t;

typedef struct _filesystem_ops_t {
	/* Dectect and create super block. */
        void* (* get_sb)(harddisk_t *);

	/* file and directory operations */
	struct _inode_t	*(* lookup)(char *, supper_block_t *);
	size_t   	 (* read)(struct _inode_t *, void *, size_t);
}filesystem_ops_t;

typedef struct _mount_t {
	/* Mount point name */
	char	name[9];

	/* Filesystem super block */
	void *sb;

	/* File system operations */
	filesystem_ops_t *fs;

	/*
	 * Next mount point
	 */
	struct _mount_t *next;
} mount_t;

/*
 * This should be used to hold
 * information about file or directory
 */
typedef struct _inode_t {
	char	  name[MAX_FILE_NAME];

	uint32_t  block;	/* first block in the file */
	size_t	  size;		/* File size in blocks */
	
	uint32_t pos;		/* Current location */
	uint32_t sector;	/* Location for the current block */
	uint8_t	 *blk;
	
	filesystem_ops_t *fs;	/* Filesystem type */
	supper_block_t	 *sb;	/* Filesystem super block */

	/* So we can build tree if 
	 * we have to.
	 */
	struct _indoe_t *parent;
	struct _inode_t *child;
	struct _inode_t *next;
}inode_t;

/*
 * Mount points
 */
extern mount_t *mounts;

inline static int disk_bread(uint32_t start, uint32_t nblks, uint8_t *blk){
        return devices.disk->bread(0, start,
                                   nblks, (unsigned long *) blk);
}

inline static uint32_t get_blocksize() {
        return devices.disk->blksz;
}

extern void init_filesystem();
extern inode_t *lookup(char *);
extern size_t read(inode_t *, void *, size_t);
extern void close(inode_t *node);

#endif
