#ifndef _DMA_H
#define _DMA_H

#include <xtype.h>
#include <interrupts.h>
#include <thread.h>

#define MMC_DMA_CH	0

typedef struct _dma_channel_t {
	int 	 id;
	int	 dev;
	uint32_t lock;
	uint16_t status;
	void (* handler)(struct _dma_channel_t *, uint16_t);
}dma_channel_t;

extern void omap_dma_irq(int ch);
extern void dma_ch_start(int ch);
extern void dma_ch_setup(int ch,
                         uint16_t dev,
                         void (* handler)(dma_channel_t *,uint16_t status));

extern void dma_ch_free(int ch);
extern void dma_ch_set_dest(int lch,
                  	    int dest_port,
                  	    int dest_amode,
                  	    uint32_t dest_start);
extern void  dma_ch_set_src(int lch,
                  int src_port,
                  int src_amode,
                  uint32_t src_start);
void dma_set_transfer_params(int lch,
                             int data_type,
                             int elem_count,
                             int frame_count,
                             int sync_mode);

extern uint32_t dma_ch_complete(int ch);
extern void dma_disable_all();
#endif
