#ifndef _DEVICE_H
#define	_DEVICE_H

#include <xtype.h>
#include <part.h>

typedef struct _tty_device_t {
	/* Output methods */
	void (* puts) (char *);
	void (* putc) (char);

	/* Input methods */
	char (* getc) ();
}tty_device_t;

/*
 * Simple data structure to hold
 * all required devices
 */
typedef struct _devices_t {
	/* Video device */
	tty_device_t *video;

	/* Block device (DISK) */
	block_dev_desc_t *disk;
}devices_t;

extern devices_t devices;
extern tty_device_t tty_video_device;

#endif
