#ifndef _BOOTSTRAP_H
#define _BOOTSTRAP_H

#include <omap1510.h>
#include <video.h>
#include <malloc.h>

#define MAX_CMDLINE_LEN         512

typedef struct _param_t {
	// tags information
        unsigned long tags_size;
        unsigned long tags_src;
        unsigned long tags_dst;

        // Kernel information
        unsigned long kernel_size;
        unsigned long kernel_src;
        unsigned long kernel_dst;

        // Initrd information
        unsigned long initrd_size;
        unsigned long initrd_src;
        unsigned long initrd_dst;

        // Machine type
        int type;
} param_t;

typedef struct _bootstrap_info_t {
	uint32_t   _phy_jump;
	uint32_t  _virt_jump;
	uint32_t   *mmu_l1;	// MMU L1 physical address
	uint32_t   notused;	
        uint32_t   *vadd_mmu_l1;// MMU L1 virtual address
        param_t	   *params;	// Parameters get passed to us by loadin
        uint32_t   mach_type;	// Machine Type
        struct tag *tags;	// Tags address
        uint32_t   kernel;	// Kernel address
	uint32_t   mm_start;	// first address
	uint32_t   mm_end; 	// last address
}bootstrap_info_t;


typedef struct _regs_t {
	uint32_t	r0;
	uint32_t	r1;
	uint32_t	r2;
	uint32_t	r3;
	uint32_t	r4;
	uint32_t	r5;
	uint32_t	r6;
	uint32_t	r7;
	uint32_t	r8;
	uint32_t	r9;
	uint32_t	r10;
	uint32_t	r11;
	uint32_t	r12;
	uint32_t	lr;
	uint32_t	cpsr;
}regs_t;


typedef struct _image_t {
	uint32_t start;
	uint32_t size;
}image_t;

// Create memory map regions
extern void create_regions();

// Bootstrap information
extern bootstrap_info_t bootstrap_info;

// Startup the loader
extern void bootstrap_main();

extern void *__pg_alloc(uint32_t flag, size_t size);
extern void linboot(uint32_t start, uint32_t size);
extern void dump_tags();

extern uint32_t *_stubs;

static inline uint32_t virt_to_phys(uint32_t addr){
	return (addr - 0x00100000) + 0x10000000;
}

static inline uint32_t phys_to_virt(uint32_t addr){
        return (addr - 0x10000000) + 0x00100000;
}

extern void bootlinux();

#endif
