/*
 *  linux/include/asm-arm/pgtable.h
 *
 *  Copyright (C) 1995-2002 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef _ASMARM_PGTABLE_H
#define _ASMARM_PGTABLE_H

#include <config.h>

/*
 * Level 1 entries type
 */
#define L1_PTE_FAULT		0
#define L1_PTE_COARSE		1
#define L1_PTE_SECTION		2
#define L1_PTE_FINE		3

/* Hardware page table definitions.
 *
 * + Level 1 descriptor (PMD)
 *   - common
 */
#define PMD_TYPE_MASK		(3 << 0)
#define PMD_TYPE_FAULT		(0 << 0)
#define PMD_TYPE_TABLE		(1 << 0)
#define PMD_TYPE_SECT		(2 << 0)
#define PMD_BIT4		(1 << 4)
#define PMD_DOMAIN(x)		((x) << 5)
#define PMD_PROTECTION		(1 << 9)	/* v5 */

/*
 *   - section
 */
#define PMD_SECT_BUFFERABLE	(1 << 2)
#define PMD_SECT_CACHEABLE	(1 << 3)
#define PMD_SECT_AP_WRITE	(1 << 10)
#define PMD_SECT_AP_READ	(1 << 11)

#define PMD_SECT_UNCACHED	(0)
#define PMD_SECT_BUFFERED	(PMD_SECT_BUFFERABLE)
#define PMD_SECT_WT		(PMD_SECT_CACHEABLE)
#define PMD_SECT_WB		(PMD_SECT_CACHEABLE | PMD_SECT_BUFFERABLE)

/*
 * + Level 2 descriptor (PTE)
 *   - common
 */
#define PTE_TYPE_MASK		(3 << 0)
#define PTE_TYPE_FAULT		(0 << 0)
#define PTE_TYPE_LARGE		(1 << 0)
#define PTE_TYPE_SMALL		(2 << 0)
#define PTE_TYPE_EXT		(3 << 0)	/* v5 */
#define PTE_BUFFERABLE		(1 << 2)
#define PTE_CACHEABLE		(1 << 3)

/*
 *   - small page
 */
#define PTE_SMALL_AP_MASK	(0xff << 4)
#define PTE_SMALL_AP_UNO_SRO	(0x00 << 4)
#define PTE_SMALL_AP_UNO_SRW	(0x55 << 4)
#define PTE_SMALL_AP_URO_SRW	(0xaa << 4)
#define PTE_SMALL_AP_URW_SRW	(0xff << 4)

#define PTE_AP_RW		0x03

#if !defined(__ASSEMBLY__)

static inline uint32_t * MMU_L1_VADDRESS(uint32_t l1){
	uint32_t tmp = (0x000FFFFFF & l1) | CONFIG_BOOTSTRAP_DATA_START;
	
	return (uint32_t *) tmp;
}

static inline uint32_t MMU_L2_PADDRESS(uint32_t l2){
	uint32_t tmp = (l2 & 0x000FFFFFF) | CONFIG_BOOTSTRAP_DATA_BASE;
	
	return tmp;
}

typedef struct _region_t {
	uint32_t	vaddr;		// Start virtual address
	uint32_t	paddr;		// Start physical address
	uint32_t	npages;		// Max number of pages	
	uint16_t	pagesize;	// Pages size
	uint16_t	type;		// Type of the mapping
}region_t;

#endif

#endif /* _ASMARM_PGTABLE_H */
