#include <part.h>
#include <common.h>
#include <malloc.h>
#include <device.h>
#include <filesystem.h>

extern filesystem_ops_t *__setup_fat();

filesystem_ops_t *filesystems[]  = {
	NULL,
	NULL
};

mount_t *mounts = NULL;

/* Hold list of avalible partitions */
harddisk_t *hdisks = NULL;

static void __setup_filesystems() {
        filesystems[0] = __setup_fat();
}


void init_filesystem(){
	/* Build filesystem list */
	__setup_filesystems();

	/* Before we do anything, lets
	 * make sure we have disk.
	 */
	if(!devices.disk){
		return;
	}

	// Fisrt build list of partitions
	hdisks = msdos_get_hdisks(devices.disk, 0, 0, NULL);

	if(!hdisks) {
		printf("Couldn't find any valid partitions\n");
		return;
	}

	// Now lets see which file system we have
	void		 *sb 	= NULL;	
	filesystem_ops_t *fs 	= NULL;
	harddisk_t	 *hd 	= hdisks;
	mount_t		*mnt 	= NULL;
	mount_t		*last 	= mounts;
	int		idx	= 0;

	while(hd) {
		// Try and read supper block
		idx = 0;
		
		while(filesystems[idx]) {
			fs = filesystems[idx];

			sb = fs->get_sb(hd);
			if(sb){
				/* We found what we looking 
				 * for, lets leave.
				 */
				mnt 	= (mount_t *) malloc(sizeof(mount_t));
				mnt->sb = sb;	
				mnt->fs	= fs;

				sprintf(mnt->name,"mnt%d", hd->id);
				
				mnt->next = last;
				last	  = mnt;

				break;
			}

			++idx;
		}

		/* Move to the next partition */
		hd = hd->_next;
	}

	// List of mount points.
	mounts = last;
}

inode_t *lookup(char *name) {
	char    *n   = name;
	char    *l   = NULL;
	size_t  size = 0;
	mount_t *mnt = mounts;
	inode_t *node= NULL;

	if(*n == '/') {
		++n;
	}

	if(!strlen(n)){
		return NULL;
	}

	/* Get mount point name */
	l = n;
	while(*l != '\0' && *l != '/') ++l;
	size = (size_t) (l - n);

	if(!size) {
		// Couldn't find valid root
		// directory
		return NULL;
	}

	if(!l) {
		/* We are missing the file 
		 * name
		 */
		return NULL;
	}

	while(mnt) {
		if(!strncmp(n, mnt->name, size)){
			// we have fount the rigth
			// mount point.
			break;
		}
		mnt = mnt->next;
	}

	if(!mnt) {
		// Couldn't find valid mount point
		return NULL;
	}

	n = l;
	if(*l == '/'){
		n = l + 1;
	}
	

	// Lets get the filesystem to do
	// the real work
	node 	 =  mnt->fs->lookup(n, mnt->sb);

	if(node){
		node->fs = mnt->fs;
	}

	return node;
}

void close(inode_t *node){
	free(node->blk);
	free(node);
}

size_t read(inode_t *node, void *buffer , size_t size){
	// Lets try and read from
	// the file.
	return node->fs->read(node, buffer, size);
}
