#include "fat_fs.h"


size_t fat_read(inode_t *node, void *buffer, size_t size){
	fat_sb_t *sb	= (fat_sb_t *) node->sb;
	size_t   left 	= (node->size > size)? size : node->size;
	size_t 	 blksz 	= 0;
	size_t 	 clussz	= sb->cluster_size * sb->sector_size;
	size_t	 sz 	= left;
	uint32_t ret	= 0;
	uint8_t	 *buf	= (uint8_t *) buffer;
	uint8_t	 *block = (uint8_t *) buffer;

	while(left && node->block != 0x0FFFFFFF){
		blksz = (left > clussz)? clussz : left;
		block = (left > clussz)? buf	: node->blk;

		// Read cluster from the disk
		if(disk_bread(node->sector, sb->cluster_size, block)){
			printf("Error reading\n");
                	return -1;
        	}

		if(block != buf){
			// Now lets copy the data to 
			// user buffer
			bcopy((void *) node->blk, (void *) buf, blksz);
		}

		// How many bytes left
		left -= blksz;
		buf  += blksz;
	
		// Move to the next cluster
		if((ret = get_cluster(sb, &node->block)) == -1){	
			printf("FAT error\n");
			return -1;
		}else if(node->block != 0xFFFFFFFF){
			// we still have data to read
			node->sector = sb->data_start + (node->block * sb->cluster_size);
		}

	}

	// Return 0 if we eached the end
	// of the file.
	sz = (node->block == 0xFFFFFFFF)? 0 : sz;

	return sz;
}
