#ifndef _FAT_FS_H
#define _FAT_FS_H

#include <filesystem.h>
#include <fat.h>
#include <malloc.h>
#include <string.h>
#include <asm/cpu.h>

#define ROUND_INDEX(idx, boundry) ((idx + boundry - 1) & ~(boundry - 1))

extern int get_cluster(fat_sb_t *sb, uint32_t *curr);
extern int fat_lookup_node(fat_sb_t *sb, char *name, inode_t *node);
extern inode_t *fat_lookup(char *path, supper_block_t *data);
extern size_t fat_read(inode_t *node, void *buffer, size_t size);

#endif
