#!/usr/bin/env python
import os, pygtk, commands
pygtk.require('2.0')
import gtk

def read():
        output = []
        name = commands.getoutput('cat /etc/ppp/peers/gprs | grep "name " | sed "s|name ||"')
        tmp = commands.getoutput("""cat /etc/ppp/pap-secrets |  sed "s|*||g" | sed 's|"||g'""")
        password = tmp.strip()
        tmp = commands.getoutput("""cat /etc/ppp/chatscripts/gprs-connect-chat | grep "AT+CGDCONT=1" | sed "s|OK||g" | sed "s|AT+CGDCONT=1||g" | sed "s|IP||g" | sed "s|0||g" | sed "s|\.||g" | sed "s|,||g" | sed 's|"||g' | sed "s|'||g" """)
        apn = tmp.strip()
        output.append(name)
        output.append(password)
        output.append(apn)
        return output

def config(username, password, APN):
    ### Create the auth variable ###
    if username <> '':
        auth = "name " + username
    else:
        auth = "noauth"
        password = "blankpassword"

    ### GPRS Options File ###
    gprsoptions = """defaultroute            
mtu 1400
crtscts
noipdefault
ipcp-accept-local
ipcp-accept-remote
novj
novjccomp
lock
    """

    ### PAP Secrets File ###
    papsecrets = """* * "%s" *
    """ % ( password )

    ### GPRS File ###
    gprs = """%s
/dev/ttyS1
115200
asyncmap 20A0000
escape FF
file /etc/ppp/gprs-options
connect "/usr/sbin/chat -f /etc/ppp/chatscripts/gprs-connect-chat"
disconnect "/usr/sbin/chat -f /etc/ppp/chatscripts/gprs-disconnect-chat"
    """ % ( auth )

    ### GPRS Connect File ###
    gprsconnectchat = """        ABORT           'BUSY'
        ABORT           'NO ANSWER'
        ABORT           'NO CARRIER'
        ABORT           'NO DIALTONE'
        TIMEOUT         5
        ''              'AT'
        OK-ATQ0V1&C1-OK 'ATE1'
        ABORT           'ERROR'
        TIMEOUT         12
        OK              'AT&F'
        OK              'AT+CGDCONT=1,"IP","%s","0.0.0.0",0,0'
        TIMEOUT         45
        OK              'AT+CGATT=1'
        OK              'ATD*99#'
        CONNECT         ''
    """ % ( APN )

    ### GPRS Disconnect File ###
    gprsdisconnectchat = """        ABORT           BUSY
        ABORT           ERROR
        ABORT           'NO DIALTONE'
        TIMEOUT         30
        ''              '+++\c'
        SAY             " + sending break"
    """

    ### Delete the old files and create the directorys ###
    os.system("rm -Rf /etc/ppp/gprs-options")
    os.system("rm -Rf /etc/ppp/pap-secrets")
    os.system("rm -Rf /etc/ppp/peers/gprs")
    os.system("rm -Rf /etc/ppp/chatscripts/gprs-connect-chat")
    os.system("rm -Rf /etc/ppp/chatscripts/gprs-disconnect-chat")

    os.system("mkdir -p /etc/ppp/chatscripts")
    os.system("mkdir -p /etc/ppp/peers")

    ### Write the files ###
    out_file = open("/etc/ppp/gprs-options","w")
    out_file.write(gprsoptions)
    out_file.close()
    out_file = open("/etc/ppp/pap-secrets","w")
    out_file.write(papsecrets)
    out_file.close()
    out_file = open("/etc/ppp/peers/gprs","w")
    out_file.write(gprs)
    out_file.close()
    out_file = open("/etc/ppp/chatscripts/gprs-connect-chat","w")
    out_file.write(gprsconnectchat)
    out_file.close()
    out_file = open("/etc/ppp/chatscripts/gprs-disconnect-chat","w")
    out_file.write(gprsdisconnectchat)
    out_file.close()



class gprsconfig:
    def connect_callback(self, widget):
        os.system("/usr/sbin/pppd call gprs")
    def disconnect_callback(self, widget):
        os.system("killall /usr/sbin/pppd")
    def save_callback(self, widget):
        username_text = self.username.get_text()
        password_text = self.password.get_text()
        apn_text = self.apn.get_text()
        config(username_text, password_text, apn_text)
    def __init__(self):
        window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window.set_size_request(240, 320)
        window.set_title("GPRS Configuration Dialog")
        window.connect("delete_event", lambda w,e: gtk.main_quit())

        vbox = gtk.VBox(False, 0)
        window.add(vbox)
        vbox.show()

        data = read()

        uname = gtk.Label("Username:")
        vbox.pack_start(uname, True, True, 0)
        uname.show()
        self.username = gtk.Entry()
        self.username.set_text(data[0])
        vbox.pack_start(self.username, True, True, 0)
        self.username.show()

        pword = gtk.Label("Password:")
        vbox.pack_start(pword, True, True, 0)
        pword.show()
        self.password = gtk.Entry()
        self.password.set_text(data[1])
        vbox.pack_start(self.password, True, True, 0)
        self.password.show()


        an = gtk.Label("APN:")
        vbox.pack_start(an, True, True, 0)
        an.show()
        self.apn = gtk.Entry()
        self.apn.set_text(data[2])
        vbox.pack_start(self.apn, True, True, 0)
        self.apn.show()

        button = gtk.Button(stock=gtk.STOCK_SAVE)
        button.connect("clicked", self.save_callback)
        vbox.pack_start(button, True, True, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()

        if commands.getoutput("cat /var/run/ppp0.pid") == "cat: /var/run/ppp0.pid: No such file or directory":
            button2 = gtk.Button("Connect to GPRS")
            button2.connect("clicked", self.connect_callback)
        else:
            lac = "IP Address: " + commands.getoutput("ifconfig ppp0 | grep inet | awk '{ print $2}'")
            button2 = gtk.Button("Disconnect from GPRS")
            button2.connect("clicked", self.disconnect_callback)
            labelc = gtk.Label(lac)
            vbox.pack_start(labelc, True, True, 0)
            labelc.show()

        vbox.pack_start(button2, True, True, 0)
        button2.set_flags(gtk.CAN_DEFAULT)
        button2.grab_default()
        button2.show()

        window.show()


gprsconfig()
gtk.main()
