#ifndef _KEYCODE_H_
#define _KEYCODE_H_

/*=1*/
#define K_CTL_A		1			/* control A */
#define K_CTL_B		2
#define K_CTL_C		3
#define K_CTL_D		4
#define K_CTL_E		5
#define K_CTL_F		6
#define K_CTL_G		7
#define K_BEL		7			/* bell */
#define K_CTL_H		8
#define K_BS		8			/* backspace */
#define K_CTL_I		9
#define K_TAB		9			/* horizontal tab */
#define K_CTL_J		10
#define K_LF		10			/* line feed (newline) */
#define K_CTL_K		11
#define K_CTL_L		12
#define K_CTL_M		13
#define K_RET		13			/* return */
#define K_CTL_N		14
#define K_MOUSE_L       14                      /* mouse left       */
#define K_CTL_O		15
#define K_MOUSE_C       15                      /* mouse center     */
#define K_CTL_P		16
#define K_MOUSE_R       16                      /* mouse right      */
#define K_CTL_Q		17
#define K_CTL_R		18
#define K_CTL_S		19
#define K_CTL_T		20
#define K_CTL_U		21
#define K_CTL_V		22
#define K_CTL_W		23
#define K_CTL_X		24
#define K_CTL_Y		25
#define K_CTL_Z		26
#define K_CTL_LB	27			/* control [ */
#define K_ESC		27			/* escape	 */
#define K_CTL_BSLSH	28			/* control \ */
#define K_CTL_RB	29			/* control ] */
#define K_CTL_CFLEX	30			/* control ^ */
#define K_CTL_UNDER	31			/* control _ */
#define K_DEL		127			/* delete */
/**/

/*=2*/
#define K_FIND		301
#define K_INSERT	302
#define K_REMOVE	303
#define K_SELECT	304
#define K_PREV		305
#define K_NEXT		306
#define K_UP		307			/* up arrow */
#define K_DOWN		308			/* down arrow */
#define K_RIGHT		309			/* right arrow */
#define K_LEFT		310			/* left arrow */

/*
 * VT200 auxiliary keypad in "application mode".
 */
#define K_APK0		311
#define K_APK1		312
#define K_APK2		313
#define K_APK3		314
#define K_APK4		315
#define K_APK5		316
#define K_APK6		317
#define K_APK7		318
#define K_APK8		319
#define K_APK9		320
#define K_APK_MINUS	321
#define K_APK_COMMA	322
#define K_APK_PERIOD	323
#define K_APK_ENTER	324
#define K_PF1		325
#define K_PF2		326
#define K_PF3		327
#define K_PF4		328

/*
 * VT200 Top-Row function keys:
 */
#define K_F1		329
#define K_F2		330
#define K_F3		331
#define K_F4		332
#define K_F5		333
#define K_F6		334
#define K_F7		335
#define K_F8		336
#define K_F9		337
#define K_F10		338
#define K_F11		339
#define K_F12		340
#define K_F13		341
#define K_F14		342
#define K_F15		343
#define K_HELP		343
#define K_F16		344
#define K_DO		344
#define K_F17		345
#define K_F18		346
#define K_F19		347
#define K_F20		348

#endif /* _KEYCODE_H_ */

